"""Update prices for ZSB in Turkey (GEOADVDEV-2880)

Revision ID: fd863f49ac9a
Revises: 1d9cb9ff41f1
Create Date: 2020-02-17 15:20:52.943136

"""
import sqlalchemy as sa
from alembic import op

from maps_adv.billing_proxy.lib.db.migration_helpers import data_migration

# revision identifiers, used by Alembic.
revision = "fd863f49ac9a"
down_revision = "1d9cb9ff41f1"
branch_labels = None
depends_on = None

product_version_id = 145


@data_migration
def upgrade():
    con = op.get_bind()

    con.execute(
        sa.text(
            """
            UPDATE product_rules_versions
            SET billing_data = '{"base_cpm": "15.0", "cpm_values": {"big": "10.0", "small": "15.0", "very_big": "10.0"}}'
            WHERE id = :product_version_id
                AND billing_data = '{"base_cpm": "12.0", "cpm_values": {"big": "6.0", "small": "12.0", "very_big": "4.0"}}'::jsonb
        """  # noqa: E501
        ),
        product_version_id=product_version_id,
    )


@data_migration
def downgrade():
    con = op.get_bind()

    con.execute(
        sa.text(
            """
                UPDATE product_rules_versions
                SET billing_data = '{"base_cpm": "12.0", "cpm_values": {"big": "6.0", "small": "12.0", "very_big": "4.0"}}'
                WHERE id = :product_version_id
                    AND billing_data = '{"base_cpm": "15.0", "cpm_values": {"big": "10.0", "small": "15.0", "very_big": "10.0"}}'::jsonb
            """  # noqa: E501
        ),
        product_version_id=product_version_id,
    )
