"""Change price for yearly product (GEOADVDEV-2643)

Revision ID: 871ef46cd32d
Revises: 5b22916bad99
Create Date: 2020-03-06 14:47:41.273802

"""
from datetime import datetime

import pytz
import sqlalchemy as sa
from alembic import op

from maps_adv.billing_proxy.lib.db.migration_helpers import data_migration

# revision identifiers, used by Alembic.
revision = "871ef46cd32d"
down_revision = "5b22916bad99"
branch_labels = None
depends_on = None

_moscow_tz = pytz.timezone("Europe/Moscow")
product_version_id = 148
activation_dt = _moscow_tz.localize(datetime(2020, 3, 6, 15))


@data_migration
def upgrade():
    con = op.get_bind()

    con.execute(
        sa.text(
            """
            WITH prev_version AS (
                UPDATE product_rules_versions
                SET active_to = :activation_dt
                WHERE id = :version_id
                RETURNING *
            )
            INSERT INTO product_rules_versions (product_id, version, active_from, active_to, billing_data, min_budget, cpm_filters)
            SELECT
                product_id,
                version + 1,
                :activation_dt,
                NULL,
                '{"base_cpm": "20.0"}'::jsonb,
                min_budget,
                cpm_filters
            FROM prev_version
            """  # noqa: E501
        ),
        version_id=product_version_id,
        activation_dt=activation_dt,
    )


@data_migration
def downgrade():
    pass
