"""Add ext_id and service_id fields to orders table

Revision ID: c2bd8916f213
Revises: a1ab2ea63948
Create Date: 2020-09-24 14:47:39.261659

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "c2bd8916f213"
down_revision = "a1ab2ea63948"
branch_labels = None
depends_on = None


def upgrade():
    op.add_column("orders", sa.Column("external_id", sa.BigInteger(), nullable=True))
    op.add_column(
        "orders",
        sa.Column("service_id", sa.BigInteger(), server_default="110", nullable=False),
    )
    op.execute("UPDATE orders SET external_id = id")
    op.alter_column("orders", "external_id", nullable=False)


def downgrade():
    op.drop_column("orders", "service_id")
    op.drop_column("orders", "external_id")
