"""empty message

Revision ID: 42b93da6be53
Revises: 3e34efe9bcb6
Create Date: 2020-11-30 13:44:57.241338

"""
import json
from datetime import datetime

import pytz
import sqlalchemy as sa
from alembic import op

from maps_adv.billing_proxy.lib.db.migration_helpers import data_migration

# revision identifiers, used by Alembic.
revision = "42b93da6be53"
down_revision = "3e34efe9bcb6"
branch_labels = None
depends_on = None

_moscow_tz = pytz.timezone("Europe/Moscow")
products_data = [
    {
        "oracle_id": 511647,
        "title": "Geoservices. Annual program 1. Branded pins on the route",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "6.12"},
        "platforms": ["NAVI", "MAPS"],
        "campaign_type": "PIN_ON_ROUTE",
        "cpm_filters": [],
    },
    {
        "oracle_id": 511648,
        "title": "Geoservices. Annual program 1. Billboard on the route",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "6.12"},
        "platforms": ["NAVI"],
        "campaign_type": "BILLBOARD",
        "cpm_filters": [],
    },
    {
        "oracle_id": 511649,
        "title": "Geoservices. Annual program 1. Banner in the Navigator",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "7.65"},
        "platforms": ["NAVI"],
        "campaign_type": "ZERO_SPEED_BANNER",
        "cpm_filters": [],
    },
    {
        "oracle_id": 511650,
        "title": "Geoservices. Annual program 1. Branded icon in the search menu",  # noqa: E501
        "billing_type": "FIX",
        "billing_data": {"cost": "10200", "time_interval": "WEEKLY"},
        "platforms": ["NAVI"],
        "campaign_type": "CATEGORY_SEARCH_PIN",
        "cpm_filters": [],
    },
    {
        "oracle_id": 511651,
        "title": "Geoservices. Annual program 1. Route recommendation",  # noqa: E501
        "billing_type": "FIX",
        "billing_data": {"cost": "38250", "time_interval": "MONTHLY"},
        "platforms": ["NAVI"],
        "campaign_type": "VIA_POINTS",
        "cpm_filters": [],
    },
]


@data_migration
def upgrade():
    con = op.get_bind()

    for product_data in products_data:
        con.execute(
            sa.text(
                """
                WITH product_rules AS (
                    SELECT product_rules_versions.*
                    FROM product_rules_versions
                    INNER JOIN (
                        SELECT product_id, max(version) AS version
                        FROM product_rules_versions
                        WHERE product_id IN (
                            SELECT id FROM products WHERE oracle_id = :oracle_id
                        )
                        GROUP BY product_id) AS product_rules_versions_subq
                    ON product_rules_versions_subq.product_id = product_rules_versions.product_id
                    AND product_rules_versions_subq.version = product_rules_versions.version
                    WHERE '2020-12-01 00:00:00+03:00' <= coalesce(product_rules_versions.active_to, now())
                    AND '2020-12-01 00:00:00+03:00' > active_from
                ),
                updating AS (
                    UPDATE product_rules_versions
                    SET active_to = '2020-12-01 00:00:00+03:00'
                    FROM product_rules
                    WHERE product_rules.id = product_rules_versions.id
                )
                INSERT INTO product_rules_versions(
                    product_id,
                    version,
                    active_from,
                    active_to,
                    billing_data,
                    min_budget,
                    cpm_filters)
                    SELECT product_id,
                    version + 1 AS version,
                    :active_from,
                    :active_to,
                    :billing_data,
                    0,
                    :cpm_filters
                FROM product_rules
            """  # noqa: E501
            ),
            oracle_id=product_data["oracle_id"],
            active_from=_moscow_tz.localize(datetime(2020, 12, 1)),
            active_to=_moscow_tz.localize(datetime(2021, 12, 31)),
            billing_data=json.dumps(product_data["billing_data"]),
            cpm_filters=product_data["cpm_filters"],
        )


def downgrade():
    pass
