"""empty message

Revision ID: f292917fa81c
Revises: 42b93da6be53
Create Date: 2020-12-02 13:57:00.505260

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "f292917fa81c"
down_revision = "42b93da6be53"
branch_labels = None
depends_on = None

oracle_id = 511720
client_id = 30785561


def upgrade():
    con = op.get_bind()

    con.execute(
        sa.text(
            """
        WITH product AS (
            SELECT * FROM products WHERE oracle_id = :oracle_id
        )
        INSERT INTO product_client_restrictions (product_id, client_id)
        SELECT id, :client_id
        FROM product
        """
        ),
        oracle_id=oracle_id,
        client_id=client_id,
    )


def downgrade():
    pass
