"""empty message

Revision ID: 98f0ce4cac52
Revises: 3e34efe9bcb6
Create Date: 2020-12-11 13:41:21.704678

"""
import json
import logging
from datetime import datetime

import pytz
import sqlalchemy as sa
from alembic import op

from maps_adv.billing_proxy.lib.db.migration_helpers import data_migration


# revision identifiers, used by Alembic.
revision = "98f0ce4cac52"
down_revision = "f292917fa81c"
branch_labels = None
depends_on = None

_moscow_tz = pytz.timezone("Europe/Moscow")

comment = (
    "Геомедийные продукты по оферте геопродукта; https://st.yandex-team.ru/GEOPROD-3823"
)
active_from = _moscow_tz.localize(datetime(2020, 12, 11))
active_to = _moscow_tz.localize(datetime(2021, 1, 31, 23, 59, 59))

products_data = [
    {
        "oracle_id": 511764,
        "title": "Геомедийная реклама. Пины по маршруту.",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "60"},
        "platforms": ["NAVI", "MAPS"],
        "campaign_type": "PIN_ON_ROUTE",
        "cpm_filters": [
            "rubric_name_common_v2",
            "targeting_type_cascade_except_realty",
        ],
        "service_id": 37,
        "min_budget": 17500,
    },
    {
        "oracle_id": 511765,
        "title": "Билборды по маршруту",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "50"},
        "platforms": ["NAVI"],
        "campaign_type": "BILLBOARD",
        "cpm_filters": [
            "rubric_name_common_v2",
            "targeting_type_cascade_except_realty",
        ],
        "service_id": 37,
        "min_budget": 17500,
    },
    {
        "oracle_id": 511766,
        "title": "Баннер при построении маршрута",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "250"},
        "platforms": ["NAVI"],
        "campaign_type": "OVERVIEW_BANNER",
        "cpm_filters": ["targeting_type_common"],
        "service_id": 37,
        "min_budget": 0,
    },
    {
        "oracle_id": 511767,
        "title": "Геомедийная реклама. Баннер",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "220"},
        "platforms": ["NAVI"],
        "campaign_type": "ZERO_SPEED_BANNER",
        "cpm_filters": ["targeting_type_common"],
        "service_id": 37,
        "min_budget": 0,
    },
]

deprecated_products = [511503, 511504, 511505, 511506]


@data_migration
def upgrade():
    con = op.get_bind()

    product_oracle_ids = set(
        product_data["oracle_id"] for product_data in products_data
    )
    cursor = con.execute(
        sa.text(
            """
            SELECT EXISTS (
                SELECT
                FROM products
                WHERE oracle_id IN :oracle_ids
            )
        """
        ),
        oracle_ids=tuple(product_oracle_ids),
    )
    any_product_exists = cursor.scalar()
    if any_product_exists:
        logging.getLogger("alembic.runtime.migration").warning(
            "Found products with one of oracle_ids mentioned, skipping revision."
        )
        return

    for product_data in products_data:
        for platform in product_data["platforms"]:
            con.execute(
                sa.text(
                    """
                    WITH
                        inserted_product AS (
                            INSERT INTO products (
                                oracle_id,
                                title,
                                act_text,
                                description,
                                currency,
                                billing_type,
                                vat_value,
                                campaign_type,
                                platform,
                                comment,
                                available_for_agencies,
                                available_for_internal,
                                platforms,
                                service_id
                            )
                            VALUES (
                                :oracle_id,
                                :title,
                                :act_text,
                                :description,
                                :currency,
                                :billing_type,
                                :vat,
                                :campaign_type,
                                :platform,
                                :comment,
                                TRUE,
                                TRUE,
                                (:platforms)::platformtype[],
                                :service_id
                            )
                            RETURNING id
                        ),
                        inserted_version AS (
                            INSERT INTO product_rules_versions (
                                product_id,
                                version,
                                active_from,
                                active_to,
                                billing_data,
                                min_budget,
                                cpm_filters
                            )
                            SELECT id,
                                   1,
                                   :active_from,
                                   :active_to,
                                   :billing_data,
                                   :min_budget,
                                   :cpm_filters
                            FROM inserted_product
                        )
                    SELECT 1
                    """  # noqa: E501
                ),
                comment=comment,  # noqa: E501
                currency="RUB",
                vat=0.2,
                oracle_id=product_data["oracle_id"],
                title=product_data["title"],
                act_text=product_data["title"],
                description="{} {}".format(
                    product_data["oracle_id"], product_data["title"]
                ),
                billing_type=product_data["billing_type"],
                campaign_type=product_data["campaign_type"],
                platform=platform,
                platforms=[platform],
                active_from=active_from,
                active_to=active_to,
                billing_data=json.dumps(product_data["billing_data"]),
                cpm_filters=product_data["cpm_filters"],
                min_budget=product_data["min_budget"],
                service_id=product_data["service_id"],
            )
    con.execute(
        sa.text(
            """
        WITH product_rules AS (
            SELECT product_rules_versions.*
              FROM product_rules_versions
             INNER JOIN (
                SELECT product_id, max(version) AS version
                FROM product_rules_versions
                WHERE product_id IN (
                    SELECT id FROM products WHERE oracle_id IN :deprecated_products
                )
                GROUP BY product_id
             ) AS product_rules_versions_subq
                   ON product_rules_versions_subq.product_id = product_rules_versions.product_id
                  AND product_rules_versions_subq.version = product_rules_versions.version
            WHERE '2020-12-11 00:00:00' <= coalesce(product_rules_versions.active_to, now())
              AND '2020-12-11 00:00:00' > active_from
        )
        UPDATE product_rules_versions
           SET active_to = '2020-12-11 00:00:00'
         FROM product_rules
         WHERE product_rules.id = product_rules_versions.id
    """
        ),
        deprecated_products=tuple(deprecated_products),
    )


def downgrade():
    pass
