"""empty message

Revision ID: ae51be1540fc
Revises: 4da34e253f23
Create Date: 2020-12-21 12:11:29.002884

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = 'ae51be1540fc'
down_revision = '4da34e253f23'
branch_labels = None
depends_on = None


oracle_ids= [511647, 511648, 511649, 511650, 511651]
client_id = 91839742


def upgrade():
    con = op.get_bind()

    con.execute(
        sa.text(
            """
        WITH product AS (
            SELECT * FROM products WHERE oracle_id IN :oracle_ids
        )
        INSERT INTO product_client_restrictions (product_id, client_id)
        SELECT id, :client_id
        FROM product
        """
        ),
        oracle_ids=tuple(oracle_ids),
        client_id=client_id,
    )

def downgrade():
    pass
