"""empty message

Revision ID: 9fcce7aee3a5
Revises: bb3406cd35a1
Create Date: 2020-12-29 16:15:07.406453

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "9fcce7aee3a5"
down_revision = "bb3406cd35a1"
branch_labels = None
depends_on = None


oracle_ids = [511647, 511648, 511649, 511650, 511651]
client_id = 91919556


def upgrade():
    con = op.get_bind()

    con.execute(
        sa.text(
            """
        WITH product AS (
            SELECT * FROM products WHERE oracle_id IN :oracle_ids
        )
        INSERT INTO product_client_restrictions (product_id, client_id)
        SELECT id, :client_id
        FROM product
        """
        ),
        oracle_ids=tuple(oracle_ids),
        client_id=client_id,
    )


def downgrade():
    pass
