"""empty message

Revision ID: 50d90e831748
Revises: 257f8970ba36
Create Date: 2020-12-30 14:37:20.550883

"""
import sqlalchemy as sa
from alembic import op

from maps_adv.billing_proxy.lib.db.migration_helpers import data_migration

# revision identifiers, used by Alembic.
revision = "50d90e831748"
down_revision = "257f8970ba36"
branch_labels = None
depends_on = None

clients = [5811066, 86476726, 38751093, 40815723]
products_to_unlink = [
    511030,
    511031,
    511032,
    511033,
    511034,
    511303,
    511304,
    511305,
    511306,
    511307,
]


@data_migration
def upgrade():
    con = op.get_bind()
    for product in products_to_unlink:
        for client_id in clients:
            con.execute(
                sa.text(
                    """
                WITH product AS (
                    SELECT * FROM products WHERE oracle_id = :oracle_id
                )
                DELETE FROM product_client_restrictions
                WHERE client_id = :client_id
                AND product_id IN (SELECT id FROM product)
                """
                ),
                oracle_id=product,
                client_id=client_id,
            )


def downgrade():
    pass
