"""empty message

Revision ID: fb9716ed4b13
Revises: 06e4cd3920df
Create Date: 2021-01-22 18:06:49.024599

"""
from alembic import op
import sqlalchemy as sa
import maps_adv.billing_proxy.lib.db.columns
import maps_adv.billing_proxy.lib.db.enums

from maps_adv.billing_proxy.lib.db.migration_helpers import data_migration

# revision identifiers, used by Alembic.
revision = 'fb9716ed4b13'
down_revision = '06e4cd3920df'
branch_labels = None
depends_on = None


oracle_ids = [511647, 511648, 511649, 511650, 511651]
client_id = 92223207


@data_migration
def upgrade():
    con = op.get_bind()

    con.execute(
        sa.text(
            """
        WITH product AS (
            SELECT * FROM products WHERE oracle_id IN :oracle_ids
        )
        INSERT INTO product_client_restrictions (product_id, client_id)
        SELECT id, :client_id
        FROM product
        """
        ),
        oracle_ids=tuple(oracle_ids),
        client_id=client_id,
    )


def downgrade():
    pass
