"""empty message

Revision ID: d2e6c3cd273b
Revises: fb9716ed4b13
Create Date: 2021-01-26 14:22:26.250708

"""
from alembic import op
import sqlalchemy as sa
import maps_adv.billing_proxy.lib.db.columns
import maps_adv.billing_proxy.lib.db.enums

from maps_adv.billing_proxy.lib.db.migration_helpers import data_migration

# revision identifiers, used by Alembic.
revision = 'd2e6c3cd273b'
down_revision = 'fb9716ed4b13'
branch_labels = None
depends_on = None


# THT
oracle_ids = [511866]
client_id = 59383000


@data_migration
def upgrade():
    con = op.get_bind()

    con.execute(
        sa.text(
            """
        WITH product AS (
            SELECT * FROM products WHERE oracle_id IN :oracle_ids
        )
        INSERT INTO product_client_restrictions (product_id, client_id)
        SELECT id, :client_id
        FROM product
        """
        ),
        oracle_ids=tuple(oracle_ids),
        client_id=client_id,
    )


def downgrade():
    pass
