"""empty message

Revision ID: 22e09673984e
Revises: b5e753cd9d87
Create Date: 2021-01-27 16:40:05.183351

"""
import json
import logging
from datetime import datetime

import pytz

from alembic import op
import sqlalchemy as sa

import maps_adv.billing_proxy.lib.db.columns
import maps_adv.billing_proxy.lib.db.enums

from maps_adv.billing_proxy.lib.db.migration_helpers import data_migration


# revision identifiers, used by Alembic.
revision = '22e09673984e'
down_revision = 'b5e753cd9d87'
branch_labels = None
depends_on = None


_moscow_tz = pytz.timezone("Europe/Moscow")

active_from = _moscow_tz.localize(datetime(2021, 1, 1))
active_to = _moscow_tz.localize(datetime(2022, 1, 31, 23, 59, 59))

# https://st.yandex-team.ru/GEOPROD-5497#601006ebfc49a078560e693f
comment = "Новые годовые программы 2021; https://st.yandex-team.ru/GEOPROD-5497"

products_data = [
    {
        "oracle_id": 511942,
        "title": "Годовая программа № 18. Брендированные пины по маршруту",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "30"},
        "currency": "RUB",
        "platforms": ["NAVI", "MAPS"],
        "campaign_type": "PIN_ON_ROUTE",
        "cpm_filters": [
            "targeting_type_common",
        ],
        "service_id": 110,
        "min_budget": 0,
    },
    {
        "oracle_id": 511943,
        "title": "Годовая программа № 18. Билборд по маршруту",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "20"},
        "currency": "RUB",
        "platforms": ["NAVI"],
        "campaign_type": "BILLBOARD",
        "cpm_filters": [
            "targeting_type_common",
        ],
        "service_id": 110,
        "min_budget": 0,
    },
    {
        "oracle_id": 511944,
        "title": "Годовая программа № 18. Баннер в Навигаторе",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "150"},
        "currency": "RUB",
        "platforms": ["NAVI"],
        "campaign_type": "ZERO_SPEED_BANNER",
        "cpm_filters": [
            "targeting_type_common",
        ],
        "service_id": 110,
        "min_budget": 0,
    },
    {
        "oracle_id": 511945,
        "title": "Годовая программа № 18. Баннер в Метро",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "160"},
        "currency": "RUB",
        "platforms": ["METRO"],
        "campaign_type": "ROUTE_BANNER",
        "cpm_filters": [
            "targeting_type_common",
        ],
        "service_id": 110,
        "min_budget": 0,
    },
    {
        "oracle_id": 511946,
        "title": "Годовая программа № 18. Баннер при построении маршрута",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "150"},
        "currency": "RUB",
        "platforms": ["NAVI"],
        "campaign_type": "OVERVIEW_BANNER",
        "cpm_filters": [
            "targeting_type_common",
        ],
        "service_id": 110,
        "min_budget": 0,
    },
    {
        "oracle_id": 511947,
        "title": "Годовая программа № 18. Брендированная иконка в меню поиска",
        "billing_type": "FIX",
        "billing_data": {"cost": "49315.00", "time_interval": "DAILY"},
        "currency": "RUB",
        "platforms": ["NAVI"],
        "campaign_type": "CATEGORY_SEARCH_PIN",
        "cpm_filters": [],
        "service_id": 110,
        "min_budget": 0,
    },
    {
        "oracle_id": 511947,
        "title": "Годовая программа № 18. Брендированная иконка в меню поиска",
        "billing_type": "FIX",
        "billing_data": {"cost": "8219.00", "time_interval": "DAILY"},
        "currency": "RUB",
        "platforms": ["MAPS"],
        "campaign_type": "CATEGORY_SEARCH_PIN",
        "cpm_filters": [],
        "service_id": 110,
        "min_budget": 0,
    },
    {
        "oracle_id": 511948,
        "title": "Годовая программа № 18. Рекомендация маршрута",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "210"},
        "currency": "RUB",
        "platforms": ["NAVI"],
        "campaign_type": "VIA_POINTS",
        "cpm_filters": [],
        "service_id": 110,
        "min_budget": 0,
    },
]

# Connect this client to the IDs below
# PIK
client_id = 21851301

# https://st.yandex-team.ru/GEOPROD-5497#601006ebfc49a078560e693f
# https://st.yandex-team.ru/GEODISPLAY-38
oracle_ids_to_bind = [511942, 511943, 511944, 511945, 511946, 511947, 511948]

# https://st.yandex-team.ru/GEOADVDEV-3038#601005a7985485242ba0368b
# https://st.yandex-team.ru/GEODISPLAY-37
products_to_unlink = [511167, 511168, 511169, 511170, 511171]

@data_migration
def upgrade():
    con = op.get_bind()

    product_oracle_ids = set(
        product_data["oracle_id"] for product_data in products_data
    )
    cursor = con.execute(
        sa.text(
            """
            SELECT EXISTS (
                SELECT
                FROM products
                WHERE oracle_id IN :oracle_ids
            )
        """
        ),
        oracle_ids=tuple(product_oracle_ids),
    )
    any_product_exists = cursor.scalar()
    if any_product_exists:
        logging.getLogger("alembic.runtime.migration").warning(
            "Found products with one of oracle_ids mentioned, skipping revision."
        )
        return

    for product_data in products_data:
        for platform in product_data["platforms"]:
            con.execute(
                sa.text(
                    """
                    WITH
                        inserted_product AS (
                            INSERT INTO products (
                                oracle_id,
                                title,
                                act_text,
                                description,
                                currency,
                                billing_type,
                                vat_value,
                                campaign_type,
                                platform,
                                comment,
                                available_for_agencies,
                                available_for_internal,
                                platforms,
                                service_id
                            )
                            VALUES (
                                :oracle_id,
                                :title,
                                :act_text,
                                :description,
                                :currency,
                                :billing_type,
                                :vat,
                                :campaign_type,
                                :platform,
                                :comment,
                                TRUE,
                                TRUE,
                                (:platforms)::platformtype[],
                                :service_id
                            )
                            RETURNING id
                        ),
                        inserted_version AS (
                            INSERT INTO product_rules_versions (
                                product_id,
                                version,
                                active_from,
                                active_to,
                                billing_data,
                                min_budget,
                                cpm_filters
                            )
                            SELECT id,
                                   1,
                                   :active_from,
                                   :active_to,
                                   :billing_data,
                                   :min_budget,
                                   :cpm_filters
                            FROM inserted_product
                        )
                    SELECT 1
                    """  # noqa: E501
                ),
                comment=comment,  # noqa: E501
                currency="RUB",
                vat=0.2,
                oracle_id=product_data["oracle_id"],
                title=product_data["title"],
                act_text=product_data["title"],
                description="{} {}".format(
                    product_data["oracle_id"], product_data["title"]
                ),
                billing_type=product_data["billing_type"],
                campaign_type=product_data["campaign_type"],
                platform=platform,
                platforms=[platform],
                active_from=active_from,
                active_to=active_to,
                billing_data=json.dumps(product_data["billing_data"]),
                cpm_filters=product_data["cpm_filters"],
                min_budget=product_data["min_budget"],
                service_id=product_data["service_id"],
            )

# https://st.yandex-team.ru/GEOADVDEV-3038#601005a7985485242ba0368b
    for product in products_to_unlink:
        con.execute(
            sa.text(
                """
            WITH product AS (
                SELECT * FROM products WHERE oracle_id = :oracle_id
            )
            DELETE FROM product_client_restrictions
            WHERE client_id = :client_id
            AND product_id IN (SELECT id FROM product)
            """
            ),
            oracle_id=product,
            client_id=client_id,
        )

# https://st.yandex-team.ru/GEOPROD-5497#601006ebfc49a078560e693f
    con.execute(
        sa.text(
            """
        WITH product AS (
            SELECT * FROM products WHERE oracle_id IN :oracle_ids
        )
        INSERT INTO product_client_restrictions (product_id, client_id)
        SELECT id, :client_id
        FROM product
        """
        ),
        oracle_ids=tuple(oracle_ids_to_bind),
        client_id=client_id,
    )



def downgrade():
    pass
