"""empty message

Revision ID: d7938c4b7f48
Revises: e32d4ab09c9e
Create Date: 2021-08-04 13:11:41.193683

"""
import json
import logging
from datetime import datetime

import pytz

from alembic import op
import sqlalchemy as sa

import maps_adv.billing_proxy.lib.db.columns
import maps_adv.billing_proxy.lib.db.enums

from maps_adv.billing_proxy.lib.db.migration_helpers import data_migration


# revision identifiers, used by Alembic.
revision = 'd7938c4b7f48'
down_revision = 'e32d4ab09c9e'
branch_labels = None
depends_on = None


_moscow_tz = pytz.timezone("Europe/Moscow")

active_from = _moscow_tz.localize(datetime(2021, 1, 1))
active_to = _moscow_tz.localize(datetime(2021, 12, 31, 23, 59, 59))

# https://st.yandex-team.ru/GEODISPLAY-280
comment = "Добавление недостающих продуктов 2021, Белоруссия; https://st.yandex-team.ru/GEODISPLAY-280"

products_data = [
    {
        "oracle_id": 510728,
        "title": "Геомедийная реклама. Пины по маршруту.",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "1.7"},
        "currency": "BYN",
        "platforms": ["MAPS"],
        "campaign_type": "PIN_ON_ROUTE",
        "cpm_filters": [
            "rubric_name_common_v2",
            "targeting_type_cascade_except_realty",
        ],
        "service_id": 110,
        "min_budget": 595,
    },
]

@data_migration
def upgrade():
    con = op.get_bind()

    # There is no validation on existing oracle_id here, as the product being added already exists for NAVI

    for product_data in products_data:
        for platform in product_data["platforms"]:
            con.execute(
                sa.text(
                    """
                    WITH
                        inserted_product AS (
                            INSERT INTO products (
                                oracle_id,
                                title,
                                act_text,
                                description,
                                currency,
                                billing_type,
                                vat_value,
                                campaign_type,
                                platform,
                                comment,
                                available_for_agencies,
                                available_for_internal,
                                platforms,
                                service_id
                            )
                            VALUES (
                                :oracle_id,
                                :title,
                                :act_text,
                                :description,
                                :currency,
                                :billing_type,
                                :vat,
                                :campaign_type,
                                :platform,
                                :comment,
                                TRUE,
                                TRUE,
                                (:platforms)::platformtype[],
                                :service_id
                            )
                            RETURNING id
                        ),
                        inserted_version AS (
                            INSERT INTO product_rules_versions (
                                product_id,
                                version,
                                active_from,
                                active_to,
                                billing_data,
                                min_budget,
                                cpm_filters
                            )
                            SELECT id,
                                   1,
                                   :active_from,
                                   :active_to,
                                   :billing_data,
                                   :min_budget,
                                   :cpm_filters
                            FROM inserted_product
                        )
                    SELECT 1
                    """  # noqa: E501
                ),
                comment=comment,  # noqa: E501
                currency="BYN",
                vat=0.2,
                oracle_id=product_data["oracle_id"],
                title=product_data["title"],
                act_text=product_data["title"],
                description="{} {}".format(
                    product_data["oracle_id"], product_data["title"]
                ),
                billing_type=product_data["billing_type"],
                campaign_type=product_data["campaign_type"],
                platform=platform,
                platforms=[platform],
                active_from=active_from,
                active_to=active_to,
                billing_data=json.dumps(product_data["billing_data"]),
                cpm_filters=product_data["cpm_filters"],
                min_budget=product_data["min_budget"],
                service_id=product_data["service_id"],
            )



def downgrade():
    pass
