"""Use contract to restrict client to product

Revision ID: 8adce22dd421
Revises: 9bdeabcbd32b
Create Date: 2021-03-21 21:00:59.343806

"""
from alembic import op
import sqlalchemy as sa
import maps_adv.billing_proxy.lib.db.columns
import maps_adv.billing_proxy.lib.db.enums


# revision identifiers, used by Alembic.
revision = "8adce22dd421"
down_revision = "9bdeabcbd32b"
branch_labels = None
depends_on = None


def upgrade():
    op.add_column(
        "product_client_restrictions",
        sa.Column("contract_id", sa.BigInteger(), nullable=True),
    )
    op.create_foreign_key(
        op.f("fk_product_client_restrictions_contract_id_contracts"),
        "product_client_restrictions",
        "contracts",
        ["contract_id"],
        ["id"],
    )
    op.drop_index(
        "product_client_restrictions_unique_ind",
        table_name="product_client_restrictions",
    )
    op.create_index(
        "product_client_restrictions_unique_ind",
        "product_client_restrictions",
        ["product_id", "client_id", "contract_id"],
        unique=True,
    )


def downgrade():
    op.drop_index(
        "product_client_restrictions_unique_ind",
        table_name="product_client_restrictions",
    )
    op.create_index(
        "product_client_restrictions_unique_ind",
        "product_client_restrictions",
        ["product_id", "client_id"],
        unique=True,
    )
    op.drop_constraint(
        op.f("fk_product_client_restrictions_contract_id_contracts"),
        "product_client_restrictions",
        type_="foreignkey",
    )
    op.drop_column("product_client_restrictions", "contract_id")
