"""Add `has_accepted_offer` column

Revision ID: 132c02088894
Revises: 8adce22dd421
Create Date: 2021-08-05 16:26:06.758765

"""
from alembic import op
import sqlalchemy as sa
import maps_adv.billing_proxy.lib.db.columns
import maps_adv.billing_proxy.lib.db.enums


# revision identifiers, used by Alembic.
revision = "132c02088894"
down_revision = "8adce22dd421"
branch_labels = None
depends_on = None


def upgrade():
    op.add_column(
        "clients",
        sa.Column(
            "has_accepted_offer",
            sa.Boolean,
            nullable=True,
            default=False,
        ),
    )


def downgrade():
    op.drop_column("clients", "has_accepted_offer")
