"""empty message

Revision ID: f7a5e01d6177
Revises: d2c020e2183f
Create Date: 2021-12-28 20:17:58.494322

"""
import json
import logging
from datetime import datetime

import pytz

from alembic import op
import sqlalchemy as sa

import maps_adv.billing_proxy.lib.db.columns
import maps_adv.billing_proxy.lib.db.enums

from maps_adv.billing_proxy.lib.db.migration_helpers import data_migration


# revision identifiers, used by Alembic.
revision = 'f7a5e01d6177'
down_revision = 'd2c020e2183f'
branch_labels = None
depends_on = None


_moscow_tz = pytz.timezone("Europe/Moscow")

active_from = _moscow_tz.localize(datetime(2021, 12, 1))
active_to = _moscow_tz.localize(datetime(2022, 2, 28, 23, 59, 59))

# https://st.yandex-team.ru/GEODISPLAY-681
comment = "Зимние пакеты 2022; https://st.yandex-team.ru/GEODISPLAY-681"

products_data = [
    {
        "oracle_id": 513210,
        "title": "Зимний.Минимум. Брендированные пины по маршруту в Геосервисах",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "55"},
        "currency": "RUB",
        "platforms": ["NAVI", "MAPS"],
        "campaign_type": "PIN_ON_ROUTE",
        "cpm_filters": [
            "targeting_type_cascade_with_audience",
        ],
        "service_id": 110,
        "type": "YEARLONG",
        "min_budget": 0,
    },
    {
        "oracle_id": 513264,
        "title": "Зимний.Минимум. Недвижимость. Брендированные пины по маршруту в Геосервисах",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "165"},
        "currency": "RUB",
        "platforms": ["NAVI", "MAPS"],
        "campaign_type": "PIN_ON_ROUTE",
        "cpm_filters": [
            "targeting_type_cascade_with_audience",
        ],
        "service_id": 110,
        "type": "YEARLONG",
        "min_budget": 0,
    },
    {
        "oracle_id": 513266,
        "title": "Зимний.Минимум. Билборды по маршруту в Геосервисах",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "35"},
        "currency": "RUB",
        "platforms": ["NAVI"],
        "campaign_type": "BILLBOARD",
        "cpm_filters": [
            "targeting_type_cascade_with_audience",
        ],
        "service_id": 110,
        "type": "YEARLONG",
        "min_budget": 0,
    },
    {
        "oracle_id": 513211,
        "title": "Зимний.Минимум. Недвижимость. Билборды по маршруту в Геосервисах",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "105"},
        "currency": "RUB",
        "platforms": ["NAVI"],
        "campaign_type": "BILLBOARD",
        "cpm_filters": [
            "targeting_type_cascade_with_audience",
        ],
        "service_id": 110,
        "type": "YEARLONG",
        "min_budget": 0,
    },
    {
        "oracle_id": 513197,
        "title": "Зимний.Минимум. Баннер в Навигаторе",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "150"},
        "currency": "RUB",
        "platforms": ["NAVI"],
        "campaign_type": "ZERO_SPEED_BANNER",
        "cpm_filters": ["targeting_type_cascade_with_audience", "creative_presence_audio_banner"],
        "service_id": 110,
        "type": "YEARLONG",
        "min_budget": 0,
    },
    {
        "oracle_id": 513269,
        "title": "Зимний.Минимум. Баннер в Метро",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "170"},
        "currency": "RUB",
        "platforms": ["METRO"],
        "campaign_type": "ROUTE_BANNER",
        "cpm_filters": [
            "targeting_type_cascade_with_audience",
        ],
        "service_id": 110,
        "type": "YEARLONG",
        "min_budget": 0,
    },
    {
        "oracle_id": 513212,
        "title": "Зимний.Минимум. Баннер при построении маршрута в Яндекс.Навигаторе",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "155"},
        "currency": "RUB",
        "platforms": ["NAVI"],
        "campaign_type": "OVERVIEW_BANNER",
        "cpm_filters": [
            "targeting_type_cascade_with_audience",
        ],
        "service_id": 110,
        "type": "YEARLONG",
        "min_budget": 0,
    },
    {
        "oracle_id": 513198,
        "title": "Зимний.Минимум. Рекомендация маршрута в Яндекс.Навигаторе",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "70"},
        "currency": "RUB",
        "platforms": ["NAVI"],
        "campaign_type": "VIA_POINTS",
        "cpm_filters": [],
        "service_id": 110,
        "type": "YEARLONG",
        "min_budget": 0,
    },
    {
        "oracle_id": 513270,
        "title": "Зимний.Минимум. Недвижимость. Рекомендация маршрута в Яндекс.Навигаторе",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "210"},
        "currency": "RUB",
        "platforms": ["NAVI"],
        "campaign_type": "VIA_POINTS",
        "cpm_filters": [],
        "service_id": 110,
        "type": "YEARLONG",
        "min_budget": 0,
    },
    {
        "oracle_id": 513213,
        "title": "Зимний.Минимум. Авто. Рекомендация маршрута в Яндекс.Навигаторе",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "140"},
        "currency": "RUB",
        "platforms": ["NAVI"],
        "campaign_type": "VIA_POINTS",
        "cpm_filters": [],
        "service_id": 110,
        "type": "YEARLONG",
        "min_budget": 0,
    },


    {
        "oracle_id": 513199,
        "title": "Зимний.Оптимум. Брендированные пины по маршруту в Геосервисах",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "50"},
        "currency": "RUB",
        "platforms": ["NAVI", "MAPS"],
        "campaign_type": "PIN_ON_ROUTE",
        "cpm_filters": [
            "targeting_type_cascade_with_audience",
        ],
        "service_id": 110,
        "type": "YEARLONG",
        "min_budget": 0,
    },
    {
        "oracle_id": 513271,
        "title": "Зимний.Оптимум. Недвижимость. Брендированные пины по маршруту в Геосервисах",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "150"},
        "currency": "RUB",
        "platforms": ["NAVI", "MAPS"],
        "campaign_type": "PIN_ON_ROUTE",
        "cpm_filters": [
            "targeting_type_cascade_with_audience",
        ],
        "service_id": 110,
        "type": "YEARLONG",
        "min_budget": 0,
    },
    {
        "oracle_id": 513214,
        "title": "Зимний.Оптимум. Билборды по маршруту в Геосервисах",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "30"},
        "currency": "RUB",
        "platforms": ["NAVI"],
        "campaign_type": "BILLBOARD",
        "cpm_filters": [
            "targeting_type_cascade_with_audience",
        ],
        "service_id": 110,
        "type": "YEARLONG",
        "min_budget": 0,
    },
    {
        "oracle_id": 513200,
        "title": "Зимний.Оптимум. Недвижимость. Билборды по маршруту в Геосервисах",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "90"},
        "currency": "RUB",
        "platforms": ["NAVI"],
        "campaign_type": "BILLBOARD",
        "cpm_filters": [
            "targeting_type_cascade_with_audience",
        ],
        "service_id": 110,
        "type": "YEARLONG",
        "min_budget": 0,
    },
    {
        "oracle_id": 513272,
        "title": "Зимний.Оптимум. Баннер в Навигаторе",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "135"},
        "currency": "RUB",
        "platforms": ["NAVI"],
        "campaign_type": "ZERO_SPEED_BANNER",
        "cpm_filters": ["targeting_type_cascade_with_audience", "creative_presence_audio_banner"],
        "service_id": 110,
        "type": "YEARLONG",
        "min_budget": 0,
    },
    {
        "oracle_id": 513215,
        "title": "Зимний.Оптимум. Баннер в Метро",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "150"},
        "currency": "RUB",
        "platforms": ["METRO"],
        "campaign_type": "ROUTE_BANNER",
        "cpm_filters": [
            "targeting_type_cascade_with_audience",
        ],
        "service_id": 110,
        "type": "YEARLONG",
        "min_budget": 0,
    },
    {
        "oracle_id": 513201,
        "title": "Зимний.Оптимум. Баннер при построении маршрута в Яндекс.Навигаторе",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "140"},
        "currency": "RUB",
        "platforms": ["NAVI"],
        "campaign_type": "OVERVIEW_BANNER",
        "cpm_filters": [
            "targeting_type_cascade_with_audience",
        ],
        "service_id": 110,
        "type": "YEARLONG",
        "min_budget": 0,
    },
    {
        "oracle_id": 513273,
        "title": "Зимний.Оптимум. Рекомендация маршрута в Яндекс.Навигаторе",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "60"},
        "currency": "RUB",
        "platforms": ["NAVI"],
        "campaign_type": "VIA_POINTS",
        "cpm_filters": [],
        "service_id": 110,
        "type": "YEARLONG",
        "min_budget": 0,
    },
    {
        "oracle_id": 513216,
        "title": "Зимний.Оптимум. Недвижимость. Рекомендация маршрута в Яндекс.Навигаторе",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "180"},
        "currency": "RUB",
        "platforms": ["NAVI"],
        "campaign_type": "VIA_POINTS",
        "cpm_filters": [],
        "service_id": 110,
        "type": "YEARLONG",
        "min_budget": 0,
    },
    {
        "oracle_id": 513202,
        "title": "Зимний.Оптимум. Авто. Рекомендация маршрута в Яндекс.Навигаторе",
        "billing_type": "CPM",
        "billing_data": {"base_cpm": "120"},
        "currency": "RUB",
        "platforms": ["NAVI"],
        "campaign_type": "VIA_POINTS",
        "cpm_filters": [],
        "service_id": 110,
        "type": "YEARLONG",
        "min_budget": 0,
    },

]


@data_migration
def upgrade():
    con = op.get_bind()

    product_oracle_ids = set(
        product_data["oracle_id"] for product_data in products_data
    )
    cursor = con.execute(
        sa.text(
            """
            SELECT EXISTS (
                SELECT
                FROM products
                WHERE oracle_id IN :oracle_ids
            )
        """
        ),
        oracle_ids=tuple(product_oracle_ids),
    )
    any_product_exists = cursor.scalar()
    if any_product_exists:
        logging.getLogger("alembic.runtime.migration").warning(
            "Found products with one of oracle_ids mentioned, skipping revision."
        )
        return

    for product_data in products_data:
        for platform in product_data["platforms"]:
            con.execute(
                sa.text(
                    """
                    WITH
                        inserted_product AS (
                            INSERT INTO products (
                                oracle_id,
                                title,
                                act_text,
                                description,
                                currency,
                                billing_type,
                                vat_value,
                                campaign_type,
                                platform,
                                comment,
                                available_for_agencies,
                                available_for_internal,
                                platforms,
                                service_id,
                                type
                            )
                            VALUES (
                                :oracle_id,
                                :title,
                                :act_text,
                                :description,
                                :currency,
                                :billing_type,
                                :vat,
                                :campaign_type,
                                :platform,
                                :comment,
                                TRUE,
                                TRUE,
                                (:platforms)::platformtype[],
                                :service_id,
                                :type
                            )
                            RETURNING id
                        ),
                        inserted_version AS (
                            INSERT INTO product_rules_versions (
                                product_id,
                                version,
                                active_from,
                                active_to,
                                billing_data,
                                min_budget,
                                cpm_filters
                            )
                            SELECT id,
                                   1,
                                   :active_from,
                                   :active_to,
                                   :billing_data,
                                   :min_budget,
                                   :cpm_filters
                            FROM inserted_product
                        )
                    SELECT 1
                    """  # noqa: E501
                ),
                comment=comment,  # noqa: E501
                currency="RUB",
                vat=0.2,
                oracle_id=product_data["oracle_id"],
                title=product_data["title"],
                act_text=product_data["title"],
                description="{} {}".format(
                    product_data["oracle_id"], product_data["title"]
                ),
                billing_type=product_data["billing_type"],
                campaign_type=product_data["campaign_type"],
                platform=platform,
                platforms=[platform],
                active_from=active_from,
                active_to=active_to,
                billing_data=json.dumps(product_data["billing_data"]),
                cpm_filters=product_data["cpm_filters"],
                min_budget=product_data["min_budget"],
                service_id=product_data["service_id"],
                type=product_data["type"],
            )


def downgrade():
    pass
