"""empty message

Revision ID: 1a66b8e3b1c9
Revises: e23f71008e73
Create Date: 2022-01-17 12:47:40.733000

"""
from alembic import op
import sqlalchemy as sa
import maps_adv.billing_proxy.lib.db.columns
import maps_adv.billing_proxy.lib.db.enums


# revision identifiers, used by Alembic.
revision = "1a66b8e3b1c9"
down_revision = "e23f71008e73"
branch_labels = None
depends_on = None

columns_list = [
    ("orders", "limit"),
    ("orders", "consumed"),
    ("order_logs", "limit"),
    ("order_logs", "consumed"),
    ("order_logs", "amount"),
    ("product_rules_versions", "min_budget"),
]

old_type = sa.Numeric(precision=20, scale=6)
new_type = sa.Numeric(precision=24, scale=10)


def upgrade():
    for table, column in columns_list:
        op.alter_column(table, column, type_=new_type)


def downgrade():
    for table, column in columns_list:
        op.alter_column(table, column, type_=old_type)
