"""GEODISPLAY-1403

Revision ID: 94cec6ac4760
Revises: 4274fab4ca12
Create Date: 2022-07-04 19:10:01.540700

"""
from alembic import op
import sqlalchemy as sa
import maps_adv.billing_proxy.lib.db.columns
import maps_adv.billing_proxy.lib.db.enums


# revision identifiers, used by Alembic.
revision = "94cec6ac4760"
down_revision = "4274fab4ca12"
branch_labels = None
depends_on = None


def upgrade():
    op.add_column(
        "clients",
        sa.Column(
            "created_at",
            sa.dialects.postgresql.TIMESTAMP(timezone=True),
            nullable=True,
        ),
    )
    op.alter_column(
        "clients", "created_at", server_default=sa.sql.expression.text("now()")
    )
    op.add_column(
        "clients",
        sa.Column(
            "representatives",
            sa.dialects.postgresql.ARRAY(sa.types.BigInteger),
            nullable=False,
            server_default="{}",
        ),
    )
    op.add_column(
        "clients",
        sa.Column(
            "created_from_cabinet",
            sa.types.Boolean,
            nullable=False,
            server_default="false",
        ),
    )


def downgrade():
    op.drop_column("clients", "created_at")
    op.drop_column("clients", "representatives")
    op.drop_column("clients", "created_from_cabinet")
