PY3TEST()

OWNER(g:maps-adv)

PEERDIR(
    maps_adv/billing_proxy

    contrib/python/pytest
    contrib/python/pytest-asyncio
    contrib/python/pytest-freezegun
    contrib/python/pytest-mock

    library/python/tvmauth

    smb/common/aiotvm/pytest
    maps_adv/common/pgswim
)

SRCDIR(maps_adv/billing_proxy)

PY_SRCS(
    __init__.py
    conftest.py
    dms.py
    domains.py
    factory.py
    helpers.py
)

TEST_SRCS(
    api/__init__.py
    api/balance/__init__.py
    api/balance/test_notify_orders.py
    api/balance/test_notify_orders_from_geoprod.py
    api/balance/test_reconciliation.py
    api/clients/__init__.py
    api/clients/test_retrieve_client.py
    api/clients/test_list_agencies.py
    api/clients/test_list_clients.py
    api/clients/test_list_agency_clients.py
    api/clients/test_list_internal_clients.py
    api/clients/test_list_client_contracts.py
    api/clients/test_list_agency_contracts.py
    api/clients/test_add_clients_to_agency.py
    api/clients/test_add_clients_to_internal.py
    api/clients/test_register_client.py
    api/clients/test_remove_clients_from_agency.py
    api/clients/test_remove_clients_from_internal.py
    api/clients/test_accept_offer.py
    api/clients/test_list_client_representatives.py
    api/orders/test_create_order.py
    api/orders/test_retrieve_order.py
    api/orders/test_retrieve_orders.py
    api/orders/test_list_agency_orders.py
    api/orders/test_list_client_orders.py
    api/orders/test_list_internal_orders.py
    api/orders/test_create_deposit_request.py
    api/orders/test_create_deposit_request_obsolete_money_format.py
    api/orders/test_list_orders_stats.py
    api/orders/test_list_orders_debits.py
    api/orders/test_list_orders_discounts.py
    api/orders/test_list_active_orders.py
    api/orders/test_update_order.py
    api/orders/charge_orders/__init__.py
    api/orders/charge_orders/test_base.py
    api/orders/charge_orders/test_insufficient_funds.py
    api/orders/charge_orders/test_bill_for_dt.py
    api/orders/charge_orders/test_skip_api_call.py
    api/orders/charge_orders/test_duplicate_charge.py
    api/orders/charge_orders_obsolete_money_format/test_base.py
    api/orders/charge_orders_obsolete_money_format/test_insufficient_funds.py
    api/orders/charge_orders_obsolete_money_format/test_bill_for_dt.py
    api/orders/charge_orders_obsolete_money_format/test_skip_api_call.py
    api/orders/charge_orders_obsolete_money_format/test_duplicate_charge.py
    api/products/__init__.py
    api/products/test_bind_unbind_client.py
    api/products/test_find_product.py
    api/products/test_list_clients.py
    api/products/test_list_products.py
    api/products/test_list_products_by_service_ids.py
    api/products/test_advise_product.py
    api/products/test_calculate_cpm.py
    api/products/test_create_product.py
    api/products/test_update_product.py
    api/system/__init__.py
    api/system/test_ping.py
    core/__init__.py
    core/test_async_xmlrpc_client.py
    core/balance_client/test_find_client.py
    core/balance_client/test_find_client_by_uid.py
    core/balance_client/test_find_clients.py
    core/balance_client/test_create_client.py
    core/balance_client/test_list_client_contracts.py
    core/balance_client/test_list_client_passports.py
    core/balance_client/test_create_order.py
    core/balance_client/test_create_deposit_request.py
    core/balance_client/test_create_user_client_association.py
    core/balance_client/test_update_orders.py
    core/cpm_filters/test_rubric_name.py
    core/cpm_filters/test_targeting.py
    core/cpm_filters/test_registry.py
    core/cpm_filters/test_values_map.py
    core/cpm_filters/test_creative.py
    data_manager/__init__.py
    data_manager/base/__init__.py
    data_manager/base/test_connection.py
    data_manager/clients/test_client_exists.py
    data_manager/clients/test_agency_exists.py
    data_manager/clients/test_create_client.py
    data_manager/clients/test_find_client_locally.py
    data_manager/clients/test_import_client_from_balance.py
    data_manager/clients/test_list_agencies.py
    data_manager/clients/test_list_clients.py
    data_manager/clients/test_list_agency_clients.py
    data_manager/clients/test_add_clients_to_agency.py
    data_manager/clients/test_remove_clients_from_agency.py
    data_manager/clients/test_client_is_in_agency.py
    data_manager/clients/test_sync_clients_data_with_balance.py
    data_manager/clients/test_sync_clients_contracts_with_balance.py
    data_manager/clients/test_find_contract.py
    data_manager/clients/test_list_client_contracts.py
    data_manager/clients/test_accept_offer.py
    data_manager/clients/test_check_clients_have_agencies.py
    data_manager/clients/test_check_clients_have_orders_with_agency.py
    data_manager/orders/test_create_order.py
    data_manager/orders/test_find_order.py
    data_manager/orders/test_find_orders.py
    data_manager/orders/test_list_agency_orders.py
    data_manager/orders/test_list_client_orders.py
    data_manager/orders/test_list_inexistent_order_ids.py
    data_manager/orders/test_list_positive_balance_orders.py
    data_manager/orders/test_list_orders_stats.py
    data_manager/orders/test_list_orders_debits.py
    data_manager/orders/test_list_orders_debits_for_billed_due_to.py
    data_manager/orders/test_charge_orders.py
    data_manager/orders/test_lock_and_return_orders_balance.py
    data_manager/orders/test_update_orders_limits.py
    data_manager/orders/test_update_order.py
    data_manager/orders/test_build_reconciliation_report.py
    data_manager/orders/test_retrieve_order_id_by_external_id.py
    data_manager/orders/test_load_geoprod_reconciliation_report.py
    data_manager/products/test_bind_unbind_client.py
    data_manager/products/test_find_product.py
    data_manager/products/test_list_products.py
    data_manager/products/test_list_by_params.py
    data_manager/products/test_find_product_active_version.py
    data_manager/products/test_create_product.py
    data_manager/products/test_update_product.py
    domain/__init__.py
    domain/clients/__init__.py
    domain/clients/test_register_client.py
    domain/clients/test_retrieve_client.py
    domain/clients/test_list_agencies.py
    domain/clients/test_list_clients.py
    domain/clients/test_list_agency_clients.py
    domain/clients/test_list_internal_clients.py
    domain/clients/test_list_agency_contracts.py
    domain/clients/test_list_client_contracts.py
    domain/clients/test_list_client_representatives.py
    domain/clients/test_add_clients_to_agency.py
    domain/clients/test_add_clients_to_internal.py
    domain/clients/test_add_user_to_client.py
    domain/clients/test_remove_clients_from_agency.py
    domain/clients/test_remove_clients_from_internal.py
    domain/clients/test_sync_clients_data_and_contracts_with_balance.py
    domain/clients/test_accept_offer.py
    domain/orders/test_create_order.py
    domain/orders/test_charge_orders.py
    domain/orders/test_retrieve_orders.py
    domain/orders/test_retrieve_order.py
    domain/orders/test_list_agency_orders.py
    domain/orders/test_list_client_orders.py
    domain/orders/test_create_deposit_request.py
    domain/orders/test_list_orders_stats.py
    domain/orders/test_list_orders_debits.py
    domain/orders/test_list_orders_discounts.py
    domain/orders/test_list_active_orders.py
    domain/orders/test_update_order.py
    domain/orders/test_update_orders_limits.py
    domain/orders/test_update_order_limits_from_geoprod.py
    domain/orders/test_build_reconciliation_report.py
    domain/orders/test_load_reconciliation_report_geoprod.py
    domain/products/test_advise_product.py
    domain/products/test_billing_setuper.py
    domain/products/test_bind_unbind_client.py
    domain/products/test_calculate_cpm.py
    domain/products/test_create_product.py
    domain/products/test_list_products.py
    domain/products/test_product_bindings.py
    domain/products/test_retrieve_product.py
    domain/products/test_update_product.py
    periodical_tasks/__init__.py
    periodical_tasks/test_tasks_are_executed.py
)

INCLUDE(${ARCADIA_ROOT}/library/recipes/docker_compose/recipe.inc)

ENV(DATABASE_URL_FOR_TESTS=postgresql://billing:billing@127.0.0.1:13000/billing)

SIZE(LARGE)

TAG(
    ya:fat
    ya:force_sandbox
    ya:nofuse
    ya:sandbox_coverage
 )

REQUIREMENTS(
    container:773239891 # xenial
    cpu:all dns:dns64
)

END()
