PY3_LIBRARY()

OWNER(g:maps-adv)

PEERDIR(
    contrib/python/aiohttp
    contrib/python/alembic
    contrib/python/sqlalchemy/sqlalchemy-1.2  # transition; see https://st.yandex-team.ru/CONTRIB-2042
    contrib/python/asyncpg
    contrib/python/marshmallow/py2
    contrib/python/marshmallow-enum/py2
    contrib/python/Faker
    contrib/python/pytz
    contrib/python/janus

    library/python/tvmauth

    smb/common/multiruntime
    smb/common/pgswim

    maps_adv/common/config_loader
    maps_adv/common/geoproduct
    maps_adv/common/protomallow
    maps_adv/warden/client
    maps_adv/billing_proxy/proto

    yt/python/client
)

PY_SRCS(
    lib/__init__.py
    lib/application.py
    lib/api/__init__.py
    lib/api/middlewares.py
    lib/api/resources/__init__.py
    lib/api/resources/balance.py
    lib/api/resources/clients.py
    lib/api/resources/orders.py
    lib/api/resources/products.py
    lib/api/resources/system.py
    lib/api/api_providers/__init__.py
    lib/api/api_providers/base.py
    lib/api/api_providers/balance.py
    lib/api/api_providers/clients.py
    lib/api/api_providers/exceptions.py
    lib/api/api_providers/orders.py
    lib/api/api_providers/products.py
    lib/api/api_providers/schemas/__init__.py
    lib/api/api_providers/schemas/balance.py
    lib/api/api_providers/schemas/base.py
    lib/api/api_providers/schemas/clients.py
    lib/api/api_providers/schemas/enums_maps.py
    lib/api/api_providers/schemas/orders.py
    lib/api/api_providers/schemas/products.py
    lib/config.py
    lib/core/__init__.py
    lib/core/async_xmlrpc_client.py
    lib/core/balance_client.py
    lib/core/cpm_filters/__init__.py
    lib/core/cpm_filters/base.py
    lib/core/cpm_filters/creative.py
    lib/core/cpm_filters/rubric_name.py
    lib/core/cpm_filters/registry.py
    lib/core/cpm_filters/targeting.py
    lib/core/cpm_filters/values_map.py
    lib/db/__init__.py
    lib/db/columns.py
    lib/db/engine.py
    lib/db/enums.py
    lib/db/migration_helpers.py
    lib/db/tables.py
    lib/data_manager/__init__.py
    lib/data_manager/exceptions.py
    lib/data_manager/base.py
    lib/data_manager/clients.py
    lib/data_manager/orders.py
    lib/data_manager/products.py
    lib/data_manager/sqls/__init__.py
    lib/data_manager/sqls/clients.py
    lib/data_manager/sqls/contracts.py
    lib/data_manager/sqls/orders.py
    lib/data_manager/sqls/products.py
    lib/domain/__init__.py
    lib/domain/clients.py
    lib/domain/enums.py
    lib/domain/exceptions.py
    lib/domain/orders.py
    lib/domain/products.py
    lib/logging.py
)

RESOURCE_FILES(
    PREFIX maps_adv/billing_proxy/
    alembic.ini
    lib/db/migrations/env.py
    lib/db/migrations/script.py.mako
    lib/db/migrations/versions/20190909_1749_f9842586227f.py
    lib/db/migrations/versions/20190916_1702_eb28f91081d0.py
    lib/db/migrations/versions/20191022_1817_5cdcc4d4fcc2.py
    lib/db/migrations/versions/20191224_2220_722da12857b9.py
    lib/db/migrations/versions/20200109_1529_b82813d20f81.py
    lib/db/migrations/versions/20200113_1449_dd6f43a2bd2d.py
    lib/db/migrations/versions/20200116_2009_51239a6a31d9.py
    lib/db/migrations/versions/20200120_1415_49c68df13fca.py
    lib/db/migrations/versions/20200122_1952_5106a2b36726.py
    lib/db/migrations/versions/20200124_1936_272cd6fbc846.py
    lib/db/migrations/versions/20200206_1744_c084d6b8252e.py
    lib/db/migrations/versions/20200210_1811_e7b581c2023e.py
    lib/db/migrations/versions/20200214_1830_1d9cb9ff41f1.py
    lib/db/migrations/versions/20200217_1520_fd863f49ac9a.py
    lib/db/migrations/versions/20200227_1752_5b22916bad99.py
    lib/db/migrations/versions/20200306_1447_871ef46cd32d.py
    lib/db/migrations/versions/20200316_2047_b3f1b645812e.py
    lib/db/migrations/versions/20200331_1929_5315f3464630.py
    lib/db/migrations/versions/20200408_1547_e73f272ae341.py
    lib/db/migrations/versions/20200417_1842_66365f7e3d75.py
    lib/db/migrations/versions/20200514_1742_82030ea13a6e.py
    lib/db/migrations/versions/20200604_1306_e34866339f9f.py
    lib/db/migrations/versions/20200911_1639_a1ab2ea63948.py
    lib/db/migrations/versions/20200924_1447_c2bd8916f213.py
    lib/db/migrations/versions/20201013_0839_e1932b45ccc9.py
    lib/db/migrations/versions/20201022_1629_b25360ee36af.py
    lib/db/migrations/versions/20201105_1312_d0161bef5b85.py
    lib/db/migrations/versions/20201112_1705_7a9aa90b6ca3.py
    lib/db/migrations/versions/20201118_1344_f3b716748a3b.py
    lib/db/migrations/versions/20201126_1721_3e34efe9bcb6.py
    lib/db/migrations/versions/20201130_1344_42b93da6be53.py
    lib/db/migrations/versions/20201202_1357_f292917fa81c.py
    lib/db/migrations/versions/20201211_1341_98f0ce4cac52.py
    lib/db/migrations/versions/20201216_1431_4da34e253f23.py
    lib/db/migrations/versions/20201221_1211_ae51be1540fc.py
    lib/db/migrations/versions/20201228_1739_bb3406cd35a1.py
    lib/db/migrations/versions/20201229_1615_9fcce7aee3a5.py
    lib/db/migrations/versions/20201229_1629_257f8970ba36.py
    lib/db/migrations/versions/20201230_1437_50d90e831748.py
    lib/db/migrations/versions/20210113_1553_05cc8be4b716.py
    lib/db/migrations/versions/20210113_2159_0ae299edba8c.py
    lib/db/migrations/versions/20210118_1637_06e4cd3920df.py
    lib/db/migrations/versions/20210122_1806_fb9716ed4b13.py
    lib/db/migrations/versions/20210126_1422_d2e6c3cd273b.py
    lib/db/migrations/versions/20210127_1433_b5e753cd9d87.py
    lib/db/migrations/versions/20210127_1640_22e09673984e.py
    lib/db/migrations/versions/20210201_2054_46f4635ac104.py
    lib/db/migrations/versions/20210202_1912_6c6a7cf74517.py
    lib/db/migrations/versions/20210209_1831_c424faab960b.py
    lib/db/migrations/versions/20210212_1620_5603ae181f82.py
    lib/db/migrations/versions/20210323_1012_52084873f91a.py
    lib/db/migrations/versions/20210330_1755_e84810f467a6.py
    lib/db/migrations/versions/20210330_1829_4698ad9bfbe9.py
    lib/db/migrations/versions/20210401_1710_0bfc36310df9.py
    lib/db/migrations/versions/20210428_0931_8a6b57eec611.py
    lib/db/migrations/versions/20210430_2042_b85b598f2557.py
    lib/db/migrations/versions/20210730_2127_e32d4ab09c9e.py
    lib/db/migrations/versions/20210804_1311_d7938c4b7f48.py
    lib/db/migrations/versions/20210804_1341_7aa7937af0fe.py
    lib/db/migrations/versions/20210804_1459_4f713ba413ff.py
    lib/db/migrations/versions/20210804_1520_175475e56a51.py
    lib/db/migrations/versions/20210804_1553_046a6c90692f.py
    lib/db/migrations/versions/20210804_2004_c367cc2287d2.py
    lib/db/migrations/versions/20210820_1951_9bdeabcbd32b.py
    lib/db/migrations/versions/20210826_2100_8adce22dd421.py
    lib/db/migrations/versions/20210827_1626_132c02088894.py
    lib/db/migrations/versions/20211012_1720_1eb7b3ec1563.py
    lib/db/migrations/versions/20211224_1241_ed749e8eb041.py
    lib/db/migrations/versions/20211227_1920_e12953426813.py
    lib/db/migrations/versions/20211228_1104_d2c020e2183f.py
    lib/db/migrations/versions/20211228_2017_f7a5e01d6177.py
    lib/db/migrations/versions/20211230_1156_1e87bc507c21.py
    lib/db/migrations/versions/20211230_1415_64b9d947bca1.py
    lib/db/migrations/versions/20211230_1559_e23f71008e73.py
    lib/db/migrations/versions/20220117_1247_1a66b8e3b1c9.py
    lib/db/migrations/versions/20220125_1130_665a1bad4d80.py
    lib/db/migrations/versions/20220125_1227_f2216655ba47.py
    lib/db/migrations/versions/20220125_1337_97b7453cbc58.py
    lib/db/migrations/versions/20220303_1025_ca8a86d6c269.py
    lib/db/migrations/versions/20220524_1800_13f7740f6e47.py
    lib/db/migrations/versions/20220602_1342_4274fab4ca12.py
    lib/db/migrations/versions/20220704_1910_94cec6ac4760.py
)

END()

RECURSE_FOR_TESTS(tests)

RECURSE(
    app
    client
    tools/import_clients
)
