import argparse

from maps_adv.call_proxy.lib import Application
from maps_adv.common.config_loader import ConfigLoader, Option
from maps_adv.common.lasagna import setup_logging

config = ConfigLoader(
    Option("TVM_DAEMON_URL", load_from="DEPLOY_TVM_TOOL_URL"),
    Option("TVM_TOKEN", load_from="TVMTOOL_LOCAL_AUTHTOKEN"),
    Option("BLACKBOX_URL", default=None),
    Option("BLACKBOX_SESSION_HOST", default=None),
)


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--host")
    parser.add_argument("--port")
    args = parser.parse_args()

    setup_logging()
    config.init()

    app = Application(config)
    app.run(host=args.host, port=args.port)


if __name__ == "__main__":
    main()
