from aiohttp import web

from smb.common.multiruntime.lib.io import setup_filesystem

from maps_adv.common.blackbox import BlackboxClient
from maps_adv.common.lasagna import Lasagna

from . import api
from .domain import Domain

setup_filesystem("maps_adv/call_proxy/")


class Application(Lasagna):
    SWIM_ENGINE_CLS = None

    async def _setup_layers(self, db: None) -> web.Application:
        clients = await self._setup_clients()
        self.domain = Domain(**clients)
        _api = api.create(self.domain)
        return _api

    async def _setup_clients(self):
        clients = {
            "blackbox_client": await BlackboxClient(
                url=self.config["BLACKBOX_URL"],
                session_host=self.config["BLACKBOX_SESSION_HOST"],
                tvm=self.tvm,
                tvm_destination="blackbox",
            ),
        }
        for client in clients.values():
            self.register_client(client)

        return clients
