from aiohttp import web

from maps_adv.call_proxy.lib.domain import Domain

from .middlewares import handle_errors
from .resources import Resources

__all__ = ["create"]


def create(domain: Domain) -> web.Application:
    api = web.Application(middlewares=[handle_errors])

    resources = Resources(domain)

    api.add_routes(
        [web.get("/ping", resources.ping), web.get("/call", resources.get_call)]
    )

    return api
