from aiohttp.web import Request, Response, middleware

from maps_adv.call_proxy.lib.exceptions import ValidationError
from maps_adv.common.blackbox import BlackboxClientException

__all__ = ["handle_errors"]


@middleware
async def handle_errors(req: Request, handler) -> Response:
    try:
        return await handler(req)
    except (ValidationError, BlackboxClientException):
        return Response(status=403)
