from aiohttp.web import FileResponse, Request, Response

from maps_adv.call_proxy.lib.domain import Domain
from maps_adv.call_proxy.lib.exceptions import ValidationError


class Resources:
    _domain: Domain

    def __init__(self, domain: Domain):
        self._domain = domain

    async def ping(self, request: Request) -> Response:
        return Response(status=200)

    async def get_call(self, request: Request) -> Response:
        if "Session_id" not in request.cookies:
            raise ValidationError

        await self._domain.get_user_ticket(
            user_ip=request.headers["X-Forwarded-For-Y"],
            session_id=request.cookies["Session_id"],
            ssl_session_id=request.cookies.get("sessionid2"),
        )
        return FileResponse(status=200, path="data/sample.mp3")
