from typing import Optional

from maps_adv.common.blackbox import BlackboxClient


class Domain:
    _blackbox_client: BlackboxClient

    def __init__(self, blackbox_client: BlackboxClient):
        self._blackbox_client = blackbox_client

    def get_call_record(self, path: str) -> None:
        return None

    async def get_user_ticket(
        self,
        user_ip: str,
        session_id: str,
        ssl_session_id: Optional[str] = None,
    ) -> None:
        blackbox_data = await self._blackbox_client.sessionid(
            user_ip=user_ip,
            session_id=session_id,
            ssl_session_id=ssl_session_id,
            get_user_ticket="yes",
        )
        return blackbox_data["user_ticket"]
