import pytest

from maps_adv.common.blackbox import BlackboxClient


@pytest.fixture(autouse=True)
async def blackbox_client(mocker, config, aiotvm):
    sessionid = mocker.patch("maps_adv.common.blackbox.BlackboxClient.sessionid")

    sessionid.return_value = {
        "status": {"value": "VALID"},
        "user_ticket": "some",
    }

    async with BlackboxClient(
        url=config["BLACKBOX_URL"],
        session_host=config["BLACKBOX_SESSION_HOST"],
        tvm=aiotvm,
        tvm_destination="blackbox",
    ) as client:
        yield client
