from typing import Any, Callable, Optional

MISSING = object()


class Option:
    __slots__ = "name", "load_from", "default", "converter"

    name: str
    load_from: str
    default: Any
    converter: Callable[[str], Any]

    def __init__(
        self,
        name: str,
        *,
        load_from: Optional[str] = None,
        default: Any = MISSING,
        converter: Optional[Callable[[str], Any]] = None,
    ):
        self.name = name
        self.load_from = load_from or name
        self.default = default
        self.converter = converter or (lambda el: el)
