import logging
import sys

__all__ = ["setup_logging"]


def setup_logging():
    format = (
        "%(asctime)s - %(levelname)-8s - %(name)s - "
        "%(message)s - [%(filename)s:%(lineno)d]"
    )

    err_handler = logging.StreamHandler(sys.stderr)
    err_handler.setLevel(logging.WARNING)

    out_handler = logging.StreamHandler(sys.stdout)
    out_handler.setLevel(logging.DEBUG)
    out_handler.addFilter(lambda log_record: log_record.levelno < logging.WARNING)

    logging.basicConfig(
        level=logging.DEBUG, format=format, handlers=[err_handler, out_handler]
    )
