class ClientException(Exception):
    pass


class UnknownResponse(ClientException):
    def __init__(self, message: str, host: str, status_code: int, payload: bytes):
        super().__init__(
            f"{message}. Status={status_code}, host={host}, payload={payload}"
        )

        self.host = host
        self.status_code = status_code
        self.payload = payload
