import logging
from .base import BaseClient
from .base.exceptions import UnknownResponse

logger = logging.getLogger()


class JugglerClient(BaseClient):
    ERROR_MESSAGE = "Reporting to Juggler failed"

    __slots__ = ["_host"]

    def __init__(self, url: str, host: str):
        super(JugglerClient, self).__init__(url=url)
        self._host = host

    async def __call__(self, description: str, service: str, status: str = "OK"):
        data = dict(
            events=[
                dict(
                    description=description,
                    host=self._host,
                    service=service,
                    status=status,
                ),
            ]
        )
        try:
            got = await self._request("POST", "/events", 200, json=data)
            if not got["success"] or not all(
                event["code"] == 200 for event in got["events"]
            ):
                logger.error(self.ERROR_MESSAGE, got)
        except UnknownResponse as e:
            logger.exception(self.ERROR_MESSAGE, exc_info=e)
