from datetime import datetime, timezone
from decimal import Decimal

import pytest

from maps_adv.common.helpers import coro_mock
from maps_adv.common.ugcdb_client import UgcdbClient


@pytest.fixture(autouse=True)
async def ugcdb_client(mocker, aiotvm):
    mock = mocker.patch(
        "maps_adv.common.ugcdb_client.UgcdbClient.fetch_org_reviews", coro_mock()
    )

    mock.coro.return_value = {
        "aggregated_rating": Decimal("4.6"),
        "review_count": 1167,
        "reviews": [
            {
                "username": "Вася.Пупкин",
                "avatar": "https://avatars.mds.yandex.net/get-yapic/43473/06aL2MjxoTMf2FvYN4V5jqHY8-1/%s",
                "updated_at": datetime(
                    2020, 9, 27, 11, 3, 12, 238000, tzinfo=timezone.utc
                ),
                "rating": 5,
                "text": "Очень вкусная старорусская кухня",
            },
            {
                "username": "Vasily P.",
                "avatar": "https://avatars.mds.yandex.net/get-yapic/61207/QmSDVrMsGTKGjBJV8wWMHheBNHA-1/%s",
                "updated_at": datetime(
                    2020, 9, 22, 17, 10, 1, 691000, tzinfo=timezone.utc
                ),
                "rating": 4,
                "text": "Очень красивый интерьер зала Библиотека.",
            },
        ],
    }

    async with UgcdbClient(
        "http://geosearch.server", tvm=aiotvm, tvm_destination="ugcdb"
    ) as client:
        yield client
