import argparse
import asyncio
import logging

from aiohttp import web

from maps_adv.export.lib import Application

parser = argparse.ArgumentParser("Exporting adv campaigns")
parser.add_argument("--host")
parser.add_argument("--port")
parser.add_argument("--config")


def main():
    logging.basicConfig(level=logging.DEBUG)
    args = parser.parse_args()

    async def start():
        app = Application()
        await app.setup(args.config)

        return app.api

    web.run_app(start(), host=args.host, port=args.port, loop=asyncio.get_event_loop())


if __name__ == "__main__":
    main()
