import json
from typing import List

from maps_adv.adv_store.api.schemas.enums import PublicationEnvEnum
from maps_adv.config_loader import Config


def _publication_env_converter(value: str) -> List[PublicationEnvEnum]:
    result = []

    for item in value.split(","):
        try:
            env = PublicationEnvEnum[item.strip().upper()]
            result.append(env)
        except KeyError:
            pass

    return result


def _ctype_converter(value: str) -> str:
    return "production" if value in ("prestable", "stable") else value


_config = {
    "RELAUNCH_INTERVAL": {"default": 60, "converter": int},
    "AVATARS_NAMESPACE": {"default": "geoadv-ext"},
    "ADV_STORE_URL": {},
    "BILLING_URL": {},
    "WARDEN_URL": {},
    "OLD_GEOADV_URL": {},
    "POINTS_URL": {},
    "POINTS_LIMIT_REQUESTS": {"default": 1, "converter": int},
    "SVG_SCALE_FACTOR": {"default": 0.25, "converter": float},
    "AVATARS_IN_MEMORY_COUNT": {"default": 50, "converter": int},
    "DASHBOARD_URL": {},
    "SANDBOX_USER": {"default": "GEOADV"},
    "SANDBOX_TOKEN": {},
    "SANDBOX_URL": {"default": "https://sandbox.yandex-team.ru"},
    "SANDBOX_PROXY_URL": {"default": "http://proxy.sandbox.yandex-team.ru"},
    "SANDBOX_EXPORT_RESOURCE_TYPE": {"default": "TYCOON_ADS"},
    "SANDBOX_EXPORT_RELEASE_TYPE": {"default": "testing"},
    "SANDBOX_EXPORT_ROOT_DIRNAME": {"default": "tycoon_ads"},
    "NANNY_SERVICE_ID": {},
    "INSTANCE_TAG_CTYPE": {"default": "testing", "converter": _ctype_converter},
    "JUGGLER_EVENTS_URL": {"default": "http://localhost:31579"},
    "FILENAME_XML": {"default": "ads.xml"},
    "XML_SCHEMA_PATH": {"default": "schemas/biz/advert/1.x/pins.xsd"},
    "W3C_SCHEMA_PATH": {"default": "schemas/w3c.xsd"},
    "NAVI_CLIENT_ID": {"default": 261, "converter": int},
    "NAVI_SIGNATURE_FILE": {},
    # settings for retrying requests to any server
    "RETRY_MAX_ATTEMPTS": {"default": 3, "converter": int},
    "RETRY_WAIT_MULTIPLIER": {"default": 0.1, "converter": float},
    # options for experiments and monkey patches
    # TODO(megadiablo) Решение об окончательном отключении кэша
    #                  примем по завершению задачи GEOADVDEV-2508
    "EXPERIMENT_WITHOUT_CACHE_POINTS": {"default": False, "converter": bool},
    # TODO(megadiablo) Флаг можно выкидывать после завершения задачи
    #                  GEOADVDEV-2482
    "EXPERIMENT_USE_HIGHLIGHTED_ATTR_FOR_PIN_SEARCH": {
        "default": [],
        "converter": _publication_env_converter,
    },
    # TODO(megadiablo) Убираем выгрузку поля stylePin для via points,
    #                  эксперемент можно закрыть, когда будет
    #                  достаточное кол-во исправленых навигаторов.
    #                  GEOADVDEV-2480, MOBNAVI-16318
    "EXPERIMENT_WITHOUT_STYLE_PIN_FOR_VIAPOINT": {
        "default": [],
        "converter": _publication_env_converter,
    },
    # TODO(megadiablo) Убрать круглые пины после того, как у навигатора
    #                  будет достаточная выкатка с исправлениями
    #                  MOBNAVI-17543, GEOADVDEV-2926
    "MONKEY_PATCH_NAVI_WITH_ROUND_PIN_FOR_PIN_ON_ROUTE": {
        "default": [],
        "converter": _publication_env_converter,
    },
    "MONKEY_PATCH_MERGE_CATEGORY_CAMPAIGNS": {
        "default": {},
        "converter": lambda data: {
            int(key): value for key, value in json.loads(data).items()
        },
    },
    "EXPERIMENT_USE_HIGHLIGHTED_ATTR_FOR_PIN_SEARCH_NAVI": {
        "default": [],
        "converter": _publication_env_converter,
    },
    "EXPERIMENT_QUARTER_HOUR_DISPLAYS_COEF": {"default": 2.0, "converter": float},
    "EXPERIMENT_QUARTER_HOUR_DISPLAYS_CAMPAIGNS": {
        "default": [],
        "converter": lambda data: [int(item) for item in data.split(",")]
        if data.strip().upper() != "ALL"
        else None,
    },
}

config = Config(_config)
