from collections import namedtuple
from typing import List

from maps_adv.common.third_party_clients.base.client import BaseClient

OrgPlace = namedtuple(
    "OrgPlace", ("address", "latitude", "longitude", "title", "permalink")
)


# TODO (shpak-vadim): refuse old monolit using,
#  go to YT for the organization's data
class OldGeoAdvClient(BaseClient):
    field_transforms = {
        "latitude": "latitude",
        "longitude": "longitude",
        "name": "title",
        "address": "address",
        "permalink": "permalink",
    }

    @classmethod
    def from_config(cls, config):
        return cls(url=config.OLD_GEOADV_URL)

    async def __call__(self, organization_ids: List[int]) -> dict:
        data = {
            "chains_included": [],
            "companies_included": organization_ids,
            "companies_excluded": [],
            "regions_included": [],
            "regions_excluded": [],
            "provider_code": "",
            "original_ids_included": [],
            "original_ids_excluded": [],
        }
        got = await self._request(
            "POST", "/campaigns/api/v2/organizations/resolve", 200, json=data
        )

        data = {}
        for org in got["orgs"]:
            data[org["permalink"]] = OrgPlace(
                latitude=org["latitude"],
                longitude=org["longitude"],
                title=org["name"],
                address=org["address"],
                permalink=org["permalink"],
            )

        return data
