from enum import Enum, auto, unique


@unique
class CampaignType(Enum):
    PIN_ON_ROUTE = auto()
    BILLBOARD = auto()
    ZERO_SPEED_BANNER = auto()
    CATEGORY_SEARCH = auto()
    ROUTE_BANNER = auto()
    ROUTE_VIA_POINT = auto()
    CATEGORY = auto()
    PIN_SEARCH = auto()
    OVERVIEW_BANNER = auto()
    PROMOCODE = auto()


@unique
class ImageType(Enum):
    LOGO = auto()
    BANNER = auto()
    BIG_BANNER = auto()

    CATEGORY = auto()

    DUST = auto()
    DUST_HOVER = auto()
    DUST_VISITED = auto()

    PIN = auto()
    PIN_HOVER = auto()
    PIN_VISITED = auto()
    PIN_SELECTED = auto()
    PIN_ROUND = auto()
    PIN_LEFT = auto()
    PIN_RIGHT = auto()


@unique
class CreativeType(Enum):
    BILLBOARD = auto()
    PIN = auto()
    PIN_SEARCH = auto()
    LOGO_AND_TEXT = auto()
    BANNER = auto()
    TEXT = auto()
    ICON = auto()
    VIA_POINT = auto()
    AUDIO_BANNER = auto()


@unique
class ActionType(Enum):
    OPEN_SITE = auto()
    SEARCH = auto()
    PHONE_CALL = auto()
    DOWNLOAD_APP = auto()
    PROMOCODE = auto()
    RESOLVE_URI = auto()
    ADD_POINT_TO_ROUTE = auto()
