import lxml.etree

from .base import XmlElement

NAMESPACES = {
    "ad": "http://maps.yandex.ru/advert/1.x",
    "biz": "http://maps.yandex.ru/business/1.x",
    "xml": "http://www.w3.org/XML/1998/namespace",
}


def xml_to_bytes(element: XmlElement, xml_declaration: bool = False) -> bytes:
    return lxml.etree.tostring(
        element, pretty_print=True, xml_declaration=xml_declaration, encoding="utf-8"
    )


def xml_to_string(element: XmlElement, xml_declaration: bool = False) -> str:
    return xml_to_bytes(element, xml_declaration=xml_declaration).decode()


def xml_namespace(name: str, namespace: str = "ad") -> str:
    return "{{{namespace}}}{name}".format(name=name, namespace=NAMESPACES[namespace])
