import logging

from maps_adv.export.lib.core.enum import CampaignType

logger = logging.getLogger(__name__)

_supported_campaign_types = {
    CampaignType.ZERO_SPEED_BANNER,
    CampaignType.OVERVIEW_BANNER,
}


class AuditPixelCampaignTypeFilter:
    async def __call__(self, campaigns: list) -> list:
        result_campaigns = []

        for campaign in campaigns:
            has_audit_pixel = (
                "settings" in campaign
                and "verification_data" in campaign["settings"]
                and campaign["settings"]["verification_data"]
            )
            if (
                has_audit_pixel
                and campaign["campaign_type"] not in _supported_campaign_types
            ):
                logger.error(
                    f"Campaign {campaign['id']} has audit pixel settings but not of the allowed campaign type. "
                    "Audit pixel settings are supported only for ZSB and OVERVIEW_BANNER campaigns, see GEODISPLAY-91 and GEODISPLAY-162."
                    "Skipping the export of the campaign."
                )
                continue
            result_campaigns.append(campaign)

        return result_campaigns
