from maps_adv.export.lib.core.enum import CampaignType

_supported_campaign_types = {
    CampaignType.ZERO_SPEED_BANNER,
    CampaignType.OVERVIEW_BANNER,
    CampaignType.PROMOCODE,
    CampaignType.ROUTE_BANNER,
}


async def polygons_resolver(campaigns: list) -> dict:
    polygons = {}
    for campaign in campaigns:
        campaign["polygons"] = []

        if campaign["campaign_type"] in _supported_campaign_types:
            areas = campaign["placing"]["area"]["areas"]
            for index, points in enumerate(areas):
                polygon_id = f"campaign:{campaign['id']}.{index + 1}"
                campaign["polygons"].append(polygon_id)
                polygons[polygon_id] = dict(id=polygon_id, points=points["points"])
    return polygons
