from maps_adv.export.lib.core.client import OldGeoAdvClient
from maps_adv.export.lib.pipeline.param import Param
from maps_adv.export.lib.pipeline.resolver import OrganizationResolver


class ResolveOrganisationsStep:
    def __init__(self, places: Param, config):
        self._client = OldGeoAdvClient.from_config(config)
        self._places = places

    async def __call__(self, campaigns):
        async with self._client as old_geoadv_client:
            await OrganizationResolver(old_geoadv_client)(campaigns, self._places.value)
