from typing import Callable


def filter_campaign_by_type(*campaign_types) -> Callable:
    def wrapped(campaign: dict) -> bool:
        return campaign["campaign_type"] in campaign_types

    return wrapped


def filter_campaign_by_platform(*platforms) -> Callable:
    def wrapped(campaign: dict) -> bool:
        return bool(set(campaign["platforms"]) & set(platforms))

    return wrapped


def filter_campaign_by_id(*id_list) -> Callable:
    def wrapped(campaign: dict) -> bool:
        return bool(campaign["id"] in id_list)

    return wrapped


def filter_campaign_by_overview_position(*values) -> Callable:
    def wrapped(campaign: dict) -> bool:
        return campaign["settings"].get("overview_position") in values

    return wrapped


def filter_without_campaign_ids(*id_list) -> Callable:
    def wrapped(campaign: dict) -> bool:
        return bool(campaign["id"] not in id_list)

    return wrapped


def drop_all(campaign: dict) -> bool:
    return False
