from maps_adv.export.lib.core.xml.base import XmlElement, XmlSchema


class ValidateXmlSchema:
    def __init__(self, schema: XmlSchema, notifier=None, raises: bool = True):
        self._notifier = notifier
        self._schema = schema
        self._raises = raises

    @classmethod
    def from_config(cls, config, notifier=None) -> "ValidateXmlSchema":
        return cls(XmlSchema.from_config(config), notifier)

    def __call__(self, xml: XmlElement):
        return self._schema.validate(xml, self._raises)
