from hashlib import md5


async def advert_tag_transform(tag: dict) -> dict:
    return dict(id=tag["id"], companies=tag["companies"])


def advert_tag_hash(advert_tag_list: list) -> str:
    canonized = set()
    for tag in advert_tag_list:
        canonized.add("{} {}".format(tag["id"], sorted(tag["companies"])))
    return md5(','.join(sorted(canonized)).encode()).hexdigest()
