from maps_adv.export.lib.core.enum import ImageType
from maps_adv.export.lib.core.utils import generate_image_filename_from_avatar


class TemplateImageFields:
    def __init__(self, images: dict, anchor: str, size: str):
        self._images = images
        self._anchor = anchor
        self._size = size

    def generate(self, name: str, image_type: ImageType) -> dict:
        if image_type in self._images:
            return {
                f"anchor{name}": self._anchor,
                f"size{name}": self._size,
                f"style{name}": generate_image_filename_from_avatar(
                    self._images[image_type]
                ),
            }
        return dict()
