import re

PHONE_REGEXP = re.compile(
    r"^\s*\+(?P<country>(?:7|375|380|90|[\d]{1,3}))\s*"
    r"\(?(?P<operator>\d{2,3}?)\)?\s*"
    r"(?P<number>\d{3}[\s-]*\d{2}[\s-]*\d{2}[\s-]*)\s*$"
)


def phone_transform(phone: str) -> dict:
    phone_number = PHONE_REGEXP.match(phone)
    country = phone_number["country"]
    operator = phone_number["operator"]
    number = phone_number["number"].replace(" ", "").replace("-", "")
    number_formatted = "{}-{}-{}".format(number[:3], number[3:5], number[5:])

    return dict(
        telephone=phone,
        formatted=f"+{country} ({operator}) {number_formatted}",
        country=country,
        prefix=operator,
        number=number,
    )
