async def polygon_transform(polygon: dict) -> dict:
    points = polygon["points"]
    # Порядок lon lat обусловлен стандартом EPSG:4326
    # https://st.yandex-team.ru/GEOADVDEV-1844#5de7bb33e9922152c51ca5f4
    # https://epsg.io/4326
    polygon_points = ", ".join(
        map(lambda item: f'{item["longitude"]} {item["latitude"]}', points)
    )

    result = dict(id=polygon["id"], polygon=f"POLYGON (({polygon_points}))")
    return result
