PY3TEST()

OWNER(g:maps-adv)

PEERDIR(
    maps_adv/export

    contrib/python/aresponses
    contrib/python/Faker
    contrib/python/pyfakefs
    contrib/python/pytest
    contrib/python/pytest-asyncio
    contrib/python/pytest-freezegun
    contrib/python/pytest-mock
    contrib/python/responses
)

SRCDIR(maps_adv/export)

PY_SRCS(
    __init__.py
    conftest.py
    api/__init__.py
    core/__init__.py
    core/client/__init__.py
    core/xml/__init__.py
    core/xml/helper/__init__.py
    pipeline/__init__.py
    pipeline/filter/__init__.py
    pipeline/resolver/__init__.py
    pipeline/resolver/organizations/__init__.py
    pipeline/resolver/pages/__init__.py
    pipeline/resolver/points/__init__.py
    pipeline/transform/__init__.py
    pipeline/validator/__init__.py
    pipeline/xml/__init__.py
    pipeline/xml/transform/__init__.py
    pipeline/xml/transform/conftest.py
    pipeline/xml/transform/pin_data/__init__.py
    pipeline/xml/tree/__init__.py
    tools.py
)

TEST_SRCS(
    api/test_ping.py
    core/test_generate_image_filename_from_avatar.py
    core/test_split_to_chunks.py
    core/test_tar_compressor.py
    core/test_url_signer.py
    core/test_utils.py
    core/client/test_old_geoadv.py
    core/client/test_sandbox.py
    core/xml/test_xml_doc.py
    core/xml/test_xml_schema.py
    core/xml/helper/test_xml_namespace.py
    core/xml/helper/test_xml_to_bytes.py
    core/xml/helper/test_xml_to_string.py
    pipeline/test_pipeline.py
    pipeline/filter/test_audit_pixel.py
    pipeline/filter/test_billing.py
    pipeline/filter/test_campaign_without_places.py
    pipeline/resolver/test_polygons_resolver.py
    pipeline/resolver/test_search_tags_resolver.py
    pipeline/resolver/test_styles.py
    pipeline/resolver/organizations/test_organizations.py
    pipeline/resolver/pages/test_feature.py
    pipeline/resolver/pages/test_resolver.py
    pipeline/resolver/points/test_get_points.py
    pipeline/transform/test_campaigns_retrieve.py
    pipeline/transform/test_apply_orders_discounts.py
    pipeline/transform/test_merge_category_campaigns.py
    pipeline/transform/test_filter_update_display_limit_excess.py
    pipeline/transform/test_split_category_search_campaigns.py
    pipeline/transform/test_split_campaigns_by_platform.py
    pipeline/transform/test_total_displays_per_campaign.py
    pipeline/xml/transform/test_actions.py
    pipeline/xml/transform/test_audit_pixel.py
    pipeline/xml/transform/test_advert_data.py
    pipeline/xml/transform/test_advert_tag.py
    pipeline/xml/transform/test_images.py
    pipeline/xml/transform/test_menu_item.py
    pipeline/xml/transform/test_phone.py
    pipeline/xml/transform/test_pipeline_data_transform.py
    pipeline/xml/transform/test_place.py
    pipeline/xml/transform/test_polygon.py
    pipeline/xml/transform/pin_data/test_billboard.py
    pipeline/xml/transform/pin_data/test_limits.py
    pipeline/xml/transform/pin_data/test_pin_on_route.py
    pipeline/xml/transform/pin_data/test_route_banner.py
    pipeline/xml/transform/pin_data/test_route_via_point.py
    pipeline/xml/transform/pin_data/test_zero_speed_banner.py
    pipeline/xml/transform/pin_data/test_overview_banner.py
    pipeline/xml/transform/pin_data/test_promocode.py
    pipeline/xml/tree/test_advert_data_list.py
    pipeline/xml/tree/test_advert_tags.py
    pipeline/xml/tree/test_menu_items.py
    pipeline/xml/tree/test_pin_data_list.py
    pipeline/xml/tree/test_places.py
    pipeline/xml/tree/test_polygons.py
    pipeline/xml/tree/test_root.py
    pipeline/validator/test_organizations.py
    pipeline/validator/test_xml_validator.py
    test_task_execution.py
)

END()
