PY3_LIBRARY()

OWNER(g:maps-adv)

PEERDIR(
    contrib/python/aiohttp
    contrib/python/cryptography
    contrib/python/marshmallow/py2
    contrib/python/pytz
    contrib/python/lxml

    sandbox/common/upload
    smb/common/multiruntime

    maps_adv/config_loader
    maps_adv/billing_proxy/client
    maps_adv/adv_store/client
    maps_adv/common/helpers
    maps_adv/common/protomallow
    maps_adv/common/third_party_clients
    maps_adv/warden/client
    maps_adv/points/proto
    maps_adv/points/client
    maps_adv/statistics/dashboard/client
)

PY_SRCS(
    lib/__init__.py
    lib/api.py
    lib/application.py
    lib/config.py

    lib/core/__init__.py
    lib/core/cache.py
    lib/core/exception.py
    lib/core/enum.py
    lib/core/filter.py
    lib/core/notifier.py
    lib/core/url_signer.py
    lib/core/utils.py

    lib/core/client/__init__.py
    lib/core/client/old_geoadv.py
    lib/core/client/points_with_cache.py
    lib/core/client/sandbox.py

    lib/core/xml/__init__.py
    lib/core/xml/base.py
    lib/core/xml/helper.py

    lib/pipeline/__init__.py
    lib/pipeline/base.py
    lib/pipeline/exceptions.py
    lib/pipeline/param.py
    lib/pipeline/transform.py

    lib/pipeline/filter/__init__.py
    lib/pipeline/filter/audit_pixel.py
    lib/pipeline/filter/campaign.py

    lib/pipeline/resolver/__init__.py
    lib/pipeline/resolver/organizations.py
    lib/pipeline/resolver/polygons.py
    lib/pipeline/resolver/search_tags.py
    lib/pipeline/resolver/styles.py

    lib/pipeline/steps/__init__.py
    lib/pipeline/steps/add_statistics.py
    lib/pipeline/steps/apply_order_discounts.py
    lib/pipeline/steps/billing.py
    lib/pipeline/steps/fetch_campaigns.py
    lib/pipeline/steps/merge_category_campaigns.py
    lib/pipeline/steps/resolve_organisations.py
    lib/pipeline/steps/resolve_pages/feature.py
    lib/pipeline/steps/resolve_pages/page.py
    lib/pipeline/steps/resolve_pages/step.py
    lib/pipeline/steps/resolve_pages/utils.py
    lib/pipeline/steps/resolve_points.py
    lib/pipeline/steps/resolve_polygons.py
    lib/pipeline/steps/search_tags.py

    lib/pipeline/validator/__init__.py
    lib/pipeline/validator/organizations.py
    lib/pipeline/validator/xml.py

    lib/pipeline/xml/__init__.py

    lib/pipeline/xml/transform/__init__.py
    lib/pipeline/xml/transform/action.py
    lib/pipeline/xml/transform/advert_data.py
    lib/pipeline/xml/transform/advert_tag.py
    lib/pipeline/xml/transform/audit_pixel.py
    lib/pipeline/xml/transform/base.py
    lib/pipeline/xml/transform/images.py
    lib/pipeline/xml/transform/menu_item.py
    lib/pipeline/xml/transform/phone.py
    lib/pipeline/xml/transform/pin_data.py
    lib/pipeline/xml/transform/place.py
    lib/pipeline/xml/transform/polygon.py

    lib/pipeline/xml/tree/__init__.py
    lib/pipeline/xml/tree/advert_data_list.py
    lib/pipeline/xml/tree/advert_tags.py
    lib/pipeline/xml/tree/menu_items.py
    lib/pipeline/xml/tree/pin_data_list.py
    lib/pipeline/xml/tree/places.py
    lib/pipeline/xml/tree/polygons.py
    lib/pipeline/xml/tree/root.py
)

RESOURCE(resources/schemas/w3c.xsd resfs/file/maps/doc/schemas/w3c.xsd)

RESOURCE_FILES(
    maps/doc/schemas/biz/advert/1.x/pins.xsd
    maps/doc/schemas/biz/advert/1.x/advert.xsd
    maps/doc/schemas/biz/advert/1.x/billboards.xsd
    maps/doc/schemas/biz/advert/1.x/common.xsd
    maps/doc/schemas/biz/advert/1.x/geoproduct.xsd
    maps/doc/schemas/biz/advert/1.x/menu.xsd
    maps/doc/schemas/biz/advert/1.x/targeting.xsd
    maps/doc/schemas/biz/advert/1.x/examples/pins.xml
    maps/doc/schemas/ymaps/ymaps/1.x/common.xsd
    maps/doc/schemas/ymaps/ymaps/1.x/phones.xsd
)

END()

RECURSE_FOR_TESTS(tests)

RECURSE(
    app
    tools
)
