import pytest

from maps_adv.common.helpers import coro_mock
from maps_adv.geosmb.booking_yang.client import BookingYangClient


@pytest.fixture(autouse=True)
async def booking_yang(config, aiotvm, mocker):
    fetch_actual_orders = mocker.patch(
        "maps_adv.geosmb.booking_yang.client.BookingYangClient.fetch_actual_orders",
        coro_mock(),
    )
    fetch_actual_orders.coro.return_value = []

    clear_orders_for_gdpr = mocker.patch(
        "maps_adv.geosmb.booking_yang.client.BookingYangClient.clear_orders_for_gdpr",
        coro_mock(),
    )
    clear_orders_for_gdpr.coro.return_value = [111, 222]

    search_orders_for_gdpr_mock = mocker.patch(
        "maps_adv.geosmb.booking_yang.client.BookingYangClient.search_orders_for_gdpr",
        coro_mock(),
    )
    search_orders_for_gdpr_mock.coro.return_value = True

    async with BookingYangClient(
        config["BOOKING_YANG_URL"], tvm=aiotvm, tvm_destination="booking_yang"
    ) as client:
        yield client
