PY3_LIBRARY()

OWNER(g:geosmb)

SUBSCRIBER(scomip)

PEERDIR(
    contrib/python/aiohttp
    contrib/python/asyncpg
    contrib/python/dateutil
    contrib/python/Jinja2
    contrib/python/lxml
    contrib/python/marshmallow/py2
    contrib/python/pytz
    contrib/python/tenacity
    contrib/python/yarl
    yql/library/python

    maps/doc/proto/yandex/maps/proto/common2
    maps/doc/proto/yandex/maps/proto/search

    smb/common/multiruntime
    smb/common/pgswim

    maps_adv/common/config_loader
    maps_adv/common/geoproduct
    maps_adv/common/helpers
    smb/common/http_client
    maps_adv/common/lasagna
    maps_adv/common/protomallow
    maps_adv/common/yasms
    maps_adv/common/yt_utils

    maps_adv/geosmb/booking_yang/proto
    maps_adv/geosmb/doorman/client

    maps_adv/geosmb/clients/geosearch
    maps_adv/warden/client
)

PY_SRCS(
    lib/__init__.py
    lib/api/__init__.py
    lib/api/middlewares.py
    lib/api/providers.py
    lib/api/resources.py
    lib/api/sensors.py
    lib/clients/__init__.py
    lib/clients/templates/__init__.py
    lib/clients/yang_client.py
    lib/data_managers/__init__.py
    lib/data_managers/orders.py
    lib/data_managers/sqls/__init__.py
    lib/data_managers/sqls/orders.py
    lib/db/engine.py
    lib/domains/__init__.py
    lib/domains/exceptions.py
    lib/domains/orders.py
    lib/domains/time_to_call_calcultator.py
    lib/enums.py
    lib/tasks.py
)

RESOURCE_FILES(
    PREFIX maps_adv/geosmb/booking_yang/server/

    lib/clients/templates/sms_booked.j2
    lib/clients/templates/sms_call_failed.j2
    lib/clients/templates/sms_generic_failure.j2
    lib/clients/templates/sms_no_place.j2
    lib/clients/templates/sms_no_place_contacts_transfered.j2
    lib/clients/templates/sms_not_enough_information.j2
    lib/clients/templates/sms_not_enough_information_contacts_transfered.j2

    lib/db/migrations/001_20201230/downgrade.sql
    lib/db/migrations/001_20201230/upgrade.sql
    lib/db/migrations/002_20201230/downgrade.sql
    lib/db/migrations/002_20201230/upgrade.sql
    lib/db/migrations/003_20201230/downgrade.sql
    lib/db/migrations/003_20201230/upgrade.sql
    lib/db/migrations/004_20210114/downgrade.sql
    lib/db/migrations/004_20210114/upgrade.sql
    lib/db/migrations/005_20210201/downgrade.sql
    lib/db/migrations/005_20210201/upgrade.sql
    lib/db/migrations/006_20210209/downgrade.sql
    lib/db/migrations/006_20210209/upgrade.sql
)

END()

RECURSE_FOR_TESTS(tests)

RECURSE(bin)
